<?php

/*
Plugin Name: WooCommerce Euplatesc Gateway
Description: Extends WooCommerce with an euplatesc gateway.
Version: 2.3.5
Author: Zamfir Vladimir
*/

	if(!defined('ABSPATH'))
		exit;

	function activate_euplatesc_gateway()
	{
		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		if( !is_plugin_active('woocommerce/woocommerce.php') )
		{
			_e('Plugin-ul woocomerce trebuie sa fie activat!', 'euplatesc_gateway');
			exit;
		}

		if( !class_exists('WC_Payment_Gateway') )
		{
			_e('Metoda de plata nu a fost gasita!', 'euplatesc_gateway');
			exit;
		}
		
		global $wpdb;
		$db_name = $wpdb->prefix . 'wc_euplatesc_trid';

		if($wpdb->get_var("show tables like '$db_name'") != $db_name) 
		{
			$sql = "CREATE TABLE " . $db_name . " (	`id` int NOT NULL AUTO_INCREMENT,`ep_id` VARCHAR (50) NOT NULL,`invoice_id` VARCHAR (50) NOT NULL,UNIQUE KEY id (id));";

			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
			dbDelta($sql);
			
		}
	}

	register_activation_hook(__FILE__, 'activate_euplatesc_gateway');
	add_action('plugins_loaded', 'woocommerce_euplatesc_init', 0);
	add_filter('woocommerce_register_shop_order_post_statuses', 'alter_statuses');
	
	function alter_statuses($order_statuses){
		$options = get_option('woocommerce_euplatesc_settings', '' );
		if(isset($options['hide_pending']) && $options['hide_pending']=="yes"){
			$order_statuses['wc-pending']['show_in_admin_all_list'] = false;
		}
		return $order_statuses;
	}

	function woocommerce_euplatesc_init()
	{
		if( class_exists('WC_Payment_Gateway') )
		{
			include_once( plugin_dir_path( __FILE__ ).'woocommerce_euplatesc_gateway.class.php' );
		} else{
			exit;
		}
		add_filter('woocommerce_payment_gateways', 'add_euplatesc_commerce_gateway');
	}

	function add_euplatesc_commerce_gateway($methods)
	{
		$methods[] = 'wc_euplatesc';
		return $methods;
	}

?>